local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"



local desbadge = Class(Widget, function(self, owner)
	Widget._ctor(self, "desbadge")
	self.owner = owner

    self:SetPosition(0,0,0)

    self.active = false

    self.drops = {}

    self.blood = 0
    self.active = false

    self.anim = self:AddChild(UIAnim())
	
	self.nameofitem = " "

	self.arrow = self.anim:AddChild(UIAnim())
	self.arrow:GetAnimState():SetBank("sanity_arrow")
	self.arrow:GetAnimState():SetBuild("sanity_arrow")
	self.arrow:GetAnimState():PlayAnimation("neutral")
	self.arrow:SetClickable(false)

    self.underNumber = self:AddChild(Widget("undernumber"))

    self.num = self:AddChild(Text(BODYTEXTFONT, 33))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(5, 0, 0)
	
	self.num:SetClickable(false)
	self.num:SetString(self.nameofitem)
	
    self.num:Show()
--	self.num:GetAnimState():SetMultColour(0.5,.5,1,0.7)
	self.thingstocraft={"axe","pickaxe","torch","campfire","firepit"}

    self:StartUpdating()


end)
---self.spitemnun = 1
function desbadge:OnUpdate(dt)
	if self.owner.components.playercontroller_3 then
		local craftnum = self.owner.components.playercontroller_3.craftnum or 0
		local itemname = self.thingstocraft[craftnum] or "axe"
		self.num:SetString("Going to craft: "..itemname..".")

	end

end



function desbadge:OnGainFocus()
	desbadge._base:OnGainFocus(self)
end

function desbadge:OnLoseFocus()
	desbadge._base:OnLoseFocus(self)
end



return desbadge